#!/bin/sh
# "magically" pick the 'best' available editor for a given platform

# use emacs if it is running a server
# disabled because I ended up not liking using emacs as $EDITOR, weird, I know
# tempuid=`id -u`
# temphost=`hostname`
# if [ -e "/tmp/esrv$tempuid-$temphost" ]
# then
#     emacsclient "$@"
#     exit $?
# fi

# use subethaedit on OS X
if test "`uname`" = "Darwin" ; then
	if test "x`whereis see`" != "x" ; then
		see -w "$@"
		exit $?
	# no subetha, then try for textwrangler
	elif test "x`whereis edit`" != "x" ; then
		edit -w "$@"
		exit $?
	fi
fi

# we're not on a mac (or preferred mac editors failed, so we like gvim
if test "x`whereis gvim`" != "x"  && test "x$DISPLAY" != "x" ; then
	gvim -f "$@"
# ...or vim, since either gvim wasn't there or display wasn't set
elif test "x`whereis vim`" != "x" ; then
	vim -f "$@"
# wow, this is a weird host, use vi. if that doesn't exist, we're really screwed
else
	vi "$@"
fi

exit $?
