;; Better buffer switching and file loading (load first in case we need the
;; * Messages * buffer)
(require 'ido)
(setq ido-enable-flex-matching t)
(ido-mode t)

(smex-initialize)

;; Python
(require 'python-mode)
(require 'ipython)

;; VCS
(require 'mercurial)
(require 'diff-mode-)
(require 'magit)

;; Hygene
(require 'whitespace)
(require 'midnight)

;; other
(require 'textmate)
(textmate-mode)
;; override what makes a project root
(setq *textmate-project-roots* '(".git" ".hg"))

(require 'yaml-mode)
(add-to-list 'auto-mode-alist '("\\.yml$" . yaml-mode))

(require 'nose)
(require 'http-twiddle)

(require 'js2-mode)
(require 'markdown-mode)
