; use tab for indent or complete
(defun indent-or-expand (arg)
  "Either indent according to mode, or expand the word preceding
point."
  (interactive "*P")
  (if (and
       (or (bobp) (= ?w (char-syntax (char-before))))
       (or (eobp) (not (= ?w (char-syntax (char-after))))))
      (dabbrev-expand arg)
    (indent-according-to-mode)))

(defun af-tab-fix ()
  (local-set-key [tab] 'indent-or-expand))

;; add hooks for modes you want to use the tab completion for:
(set-variable 'af-cleanup-whitespace t)
(add-hook 'c-mode-hook          'af-tab-fix)
(add-hook 'c++-mode-hook          'af-tab-fix)
(add-hook 'sh-mode-hook         'af-tab-fix)
(add-hook 'emacs-lisp-mode-hook 'af-tab-fix)

(defun af-c-mode-hook ()
  (interactive)
  (if (string-match "mercurial/" buffer-file-name)
      (progn
        (message "looks like an hg c file, using kernel style")
        (c-set-style "linux")
        (setq indent-tabs-mode t)
        (setq whitespace-style (remove 'indentation (remove 'tabs whitespace-style))))))
(add-hook 'c-mode-common-hook 'af-c-mode-hook)

;; disable whitespace cleanup in modes sensitive to whitespace
(defun af-no-clean-whitespace ()
  (interactive)
  (make-variable-buffer-local 'af-cleanup-whitespace)
  (set-variable 'af-cleanup-whitespace nil))
(add-hook 'rst-mode-hook 'af-no-clean-whitespace)
(add-hook 'makefile-mode-hook 'af-no-clean-whitespace)
(add-hook 'diff-mode-hook 'af-no-clean-whitespace)

(autoload 'js2-mode "js2" nil t)
(add-to-list 'auto-mode-alist '("\\.js$" . js2-mode))
(add-hook 'js2-mode-hook 'af-tab-fix)

(add-hook 'ruby-mode-hook '(lambda ()
                            (af-tab-fix)
                            (local-set-key (kbd "RET")
                                           'reindent-then-newline-and-indent)
                            (local-set-key (kbd "C-M-f")
                                           'textmate-find-in-project-type)))
(add-to-list 'auto-mode-alist '("\\.rake$" . ruby-mode))

(require 'django-html-mode)
;; I think I probably just always want it in django mode for now
(add-to-list 'auto-mode-alist '("\\.html$'" . django-html-mode))
(add-to-list 'auto-mode-alist '("\\.html.erb$'" . django-html-mode))
(add-to-list 'auto-mode-alist '("\\.rhtml$'" . django-html-mode))
(add-hook 'django-html-mode-hook '(lambda ()
                                    (local-set-key (kbd "RET")
                                                   'reindent-then-newline-and-indent)))
(defun af-python-mode-hook ()
  ; highlight tabs in Python
  (make-variable-buffer-local 'font-lock-mode-hook)
  (make-variable-buffer-local 'python-indent)
  (if (and buffer-file-name (string-match "melange" buffer-file-name))
     (set-variable 'python-indent 2))
  (af-tab-fix)
  (easy-menu-add-item nil '("Python") ["Run All Tests" nosetests-all t]
                      "Comment Out Region")
  (easy-menu-add-item nil '("Python") ["Run All Tests with --failed" nosetests-failed t]
                      "Comment Out Region")
  (easy-menu-add-item nil '("Python") ["Run Module Tests" nosetests-module t]
                      "Comment Out Region")
  (easy-menu-add-item nil '("Python") ["Run One Test" nosetests-one t]
                      "Comment Out Region")
  (easy-menu-add-item nil '("Python") ["Debug One Test" nosetests-pdb-one t]
                      "Comment Out Region")
  (easy-menu-add-item nil '("Python") ["-" nil t] "Comment Out Region")
  (local-set-key "\M-n" 'nosetests-module)
  (local-set-key "\M-\C-n" 'nosetests-one)
  (local-set-key (kbd "RET") 'comment-indent-new-line)
)
(add-hook 'python-mode-hook 'af-python-mode-hook)

(add-hook 'compilation-mode-hook '(lambda () (local-set-key "g" 'recompile)))

(column-number-mode)


(defun af-annotation-fix (unused)
  "fix indentation after an annotation"
  (save-excursion
    (beginning-of-line)
    (forward-word -1)
    (if (eq (char-before) ?@) ;; There's an annotation there
        0
      (+ c-basic-offset c-basic-offset))))

(defun af-java-mode-hook ()
  (c-set-offset 'topmost-intro-cont 'af-annotation-fix)
  (local-set-key (kbd "RET") 'comment-indent-new-line)
  (af-tab-fix))
(add-hook 'java-mode-hook 'af-java-mode-hook)

;; mq diff-mode support
(add-to-list 'auto-mode-alist '("\\.hg/patches/" . diff-mode))
(defun mq-patch-set-default-directory ()
  (when (string= ".hg" (nth 2 (reverse (split-string default-directory "/"))))
    (setq default-directory (expand-file-name (concat default-directory "../../")))))
(add-hook 'diff-mode-hook 'mq-patch-set-default-directory)

;; Tempfiles from mutt should be edited in mail-mode.
(add-to-list 'auto-mode-alist '("/mutt" . mail-mode))
