;; All lines should end in a newline
(setq require-final-newline t)

;; disable tabs
(setq tab-width 4)
(setq-default indent-tabs-mode nil)

;; Cleanup whitespace before saves.
(add-hook 'before-save-hook '(lambda ()
                               (if af-cleanup-whitespace (whitespace-cleanup))))

;; Disable that startup screen
(setq inhibit-startup-message t)

; always highlight matching paren
(show-paren-mode 1)

;; Automatically revert unedited files that change on the underlying
;; system.
(global-auto-revert-mode)

;; I like dots in my nose output
(setq nose-use-verbose nil)

;; no toolbar
(setq tool-bar-mode nil)
(tool-bar-mode 0)

; cause imenu to always rescan the buffer (for textmate-goto-symbol)
(setq imenu-auto-rescan t)
;; better uniquify from http://metapundit.net/sections/blog/emacs_and_django
(require 'uniquify)
(setq uniquify-buffer-name-style 'reverse)
(setq uniquify-separator "/")
(setq uniquify-after-kill-buffer-p t)
(setq uniquify-ignore-buffers-re "^\\*")
(setq hg-outgoing-repository "")
(setq hg-incoming-repository "")

;; Make this a function in case we have to re-run it. I've had weirdness
;; ensue with daemon mode not always initializing everything the way I want
;; in new frames.
(defun af-gui-init ()
  (interactive)
  ;; so that Cmd+H won't activate Hide Current
  ;; App and Cmd+Shift+q won't logout user.
  (setq mac-pass-command-to-system nil)

  ;; scrollbars, but on the right, not the left
  (if (window-system) (set-scroll-bar-mode 'right))

  ;; Command is meta in OS X.
  (setq ns-command-modifier (quote meta))

  ;; Don't popup new frames for opened files
  (setq ns-pop-up-frames nil)

  (cond
   ((eq window-system 'ns) ;; OS X
    (set-face-attribute 'default nil :height 120))
   (t ;; everywhere else
    (set-face-attribute 'default nil :height 105)))
)
(af-gui-init)

;; use y or n instead of yes or no
(fset 'yes-or-no-p 'y-or-n-p)
;; Enable narrow-to-region, which is disabled by default
(put 'narrow-to-region 'disabled nil)

;; whitespace detection
(setq
 whitespace-line-column 78
 whitespace-style '(face
                    trailing
                    space-after-tab
                    space-before-tab
                    lines-tail
                    indentation
                    empty
                    tabs)
 )
(global-whitespace-mode 1)

;; Disable VC plumbing since I don't really use it that much anyway
(setq vc-handled-backends nil)

;; use aspell
(setq-default ispell-program-name "aspell")
