;; completions for go
(defun af-go-hook ()
  ;; enable tabs
  (setq tab-width 2)
  (setq indent-tabs-mode t)
  (make-variable-buffer-local 'whitespace-style)
  (setq whitespace-style '(trailing lines-tail indentation trailing empty))
  (go-eldoc-setup)
  )

(defun af-get-go-elisp-location ()
  (let* ((gobinary (shell-command-to-string "which go"))
         (gobin (substring (let ((x (file-name-directory gobinary)))
                             (if x x "z")) 0  -1))
         (goroot (file-name-directory gobin)))
    (if goroot (concat goroot "misc/emacs") "")))

(defun af-get-gocode-elisp-location ()
  (let* ((binary (shell-command-to-string "which gocode"))
         (bin (substring (let ((x (file-name-directory binary)))
                               (if x x "z")) 0 -1))
         (basedir (file-name-directory bin)))
    (if basedir
        (concat basedir "src/github.com/nsf/gocode/emacs-company/")
      "")))

(let* ((goloc (af-get-go-elisp-location))
       (goel (concat goloc "/go-mode.el")))
  (if (file-exists-p goel)
      (progn
        (message "Go is installed, loading go-mode")
        (add-to-list 'load-path goloc)
        (require 'go-mode)
        (add-hook 'go-mode-hook 'af-go-hook)
        (let* ((loc (af-get-gocode-elisp-location))
               (el (concat loc "/company-go.el")))
          (if (file-exists-p el)
              (progn
                (message "Found gocode, loading company-mode support...")
                (add-to-list 'load-path loc)
                (require 'company-go))
            (message "gocode missing, skipping company-mode support."))))
    (message "Go appears to not be installed, skipping Go setup.")))
