;; Key Bindings
; M-backspace kills the current buffer
(global-set-key [(meta backspace)] 'kill-this-buffer)
(global-set-key "\M-\d" 'kill-this-buffer)
; Save early and often, with only one keystroke
(global-set-key [(meta s)] 'save-buffer)
; Typing tab is for lesser editors, make hitting return do that
(global-set-key "\C-m" 'indent-new-comment-line)
; M-l makes more sense to me for jumping to a line
(global-set-key "\M-l" 'goto-line)
; Sometimes C-h is what Backspace sends in a terminal, and I never use C-h
(global-set-key "\C-h" 'backward-delete-char-untabify)
; M-t is what I want for the textmate file finding
(global-set-key [(meta t)] 'textmate-goto-file)
; M-p for bouncing to the matching paren
(global-set-key [(meta p)] 'bounce-to-other-paren)
(global-set-key [(meta control f)] 'textmate-find-in-project-type)
(global-set-key [(meta shift f)] 'textmate-find-in-project)
(global-set-key [(meta m)] 'iconify-or-deiconify-frame)
(global-set-key [(control backspace)] 'kill-word)

(global-set-key [f3] 'next-error)
(defun af-dwim-f4 () (interactive)
  (cond ((string-match "\\.t$" buffer-file-name)
         (textmate-start-compile-in-root
          (concat "make " (file-name-nondirectory buffer-file-name))))))
(global-set-key [f4] 'af-dwim-f4)
(global-set-key [f5] 'diff-apply-hunk)

;; M-j for jump to function definition
(global-set-key [(meta j)] 'textmate-goto-symbol)

;; commit emacs heresy?
(global-set-key [(meta r)] 'smex)
(global-set-key (kbd "M-R") 'smex-major-mode-commands)

(global-set-key (kbd "C-x C-b") 'ibuffer)

;; Mac-like keybindings for undo/cut/copy/paste
(global-set-key [(meta c)] 'kill-ring-save)
(global-set-key [(meta x)] 'kill-region)
(global-set-key [(meta z)] 'undo)
(global-set-key [(meta v)] 'yank)
(global-set-key [M-return] 'fullscreen)
(global-set-key [(control v)] 'yank-pop)

;; Fixup hooks for modes that like taking my keys back
(add-hook 'text-mode-hook '(lambda ()
                             (define-key text-mode-map "\M-s"
                               'save-buffer)))
(add-hook 'comint-mode-hook '(lambda ()
                               (local-set-key "\M-r"
                                              'execute-extended-command)))

(defun server-save-buffer-and-finish ()
  (interactive)
  (save-buffer) (server-edit))
(add-hook 'server-switch-hook
          '(lambda ()(local-set-key "\M-s" 'server-save-buffer-and-finish )))
