;; Prevent TRAMP from being too clever about $PATH
(require 'tramp)
(add-to-list 'tramp-remote-path 'tramp-own-remote-path)

;; sometime in 2014 tramp started passing -l to sh, which doesn't work
;; with BSD sh. Use bash instead.
(add-to-list 'tramp-connection-properties
             (list (regexp-quote "home.durin42.com") "remote-shell" "bash"))

;; Backup (file~) disabled and auto-save (#file#) locally to prevent delays in editing remote files
(add-to-list 'backup-directory-alist
             (cons tramp-file-name-regexp nil))
(setq tramp-auto-save-directory temporary-file-directory)
